// popup.js
const emailsList = document.getElementById("emails");
const countEl = document.getElementById("count");
const copyBtn = document.getElementById("copyBtn");
const csvBtn = document.getElementById("csvBtn");
const refreshBtn = document.getElementById("refreshBtn");
const clearBtn = document.getElementById("clearBtn");

function showEmails(emails) {
  emailsList.innerHTML = "";
  emails.forEach(e => {
    const li = document.createElement("li");
    li.textContent = e;
    emailsList.appendChild(li);
  });
  countEl.textContent = emails.length;
  copyBtn.disabled = emails.length === 0;
  csvBtn.disabled = emails.length === 0;
}

function loadEmails() {
  chrome.storage.local.get(["foundEmails"], (data) => {
    const emails = Array.isArray(data.foundEmails) ? data.foundEmails : [];
    showEmails(emails);
  });
}

copyBtn.addEventListener("click", async () => {
  const emails = Array.from(emailsList.querySelectorAll("li")).map(li => li.textContent);
  try {
    await navigator.clipboard.writeText(emails.join("\n"));
    copyBtn.textContent = "Copied!";
    setTimeout(() => (copyBtn.textContent = "Copy"), 1400);
  } catch (err) {
    alert("Copy failed: " + err);
  }
});

csvBtn.addEventListener("click", () => {
  const emails = Array.from(emailsList.querySelectorAll("li")).map(li => li.textContent.trim());
  if (emails.length === 0) return;

  // Each email on its own line with trailing comma
  const csvContent = emails.map(e => e + ",").join("\n");

  // Get total emails
  const totalEmails = emails.length;

  // Get current date and time
  const now = new Date();
  const year = now.getFullYear();
  const month = String(now.getMonth() + 1).padStart(2, '0');
  const day = String(now.getDate()).padStart(2, '0');
  const hour = String(now.getHours()).padStart(2, '0');
  const minute = String(now.getMinutes()).padStart(2, '0');

  const filename = `emails_${totalEmails}_${year}-${month}-${day}_${hour}-${minute}.txt`;

  // Create blob and download
  const blob = new Blob([csvContent], { type: "text/plain;charset=utf-8;" });
  const url = URL.createObjectURL(blob);
  const a = document.createElement("a");
  a.href = url;
  a.download = filename;
  a.click();
  URL.revokeObjectURL(url);
});



refreshBtn.addEventListener("click", () => loadEmails());

clearBtn.addEventListener("click", () => {
  if (!confirm("Clear all stored emails?")) return;
  chrome.storage.local.set({ foundEmails: [] }, () => {
    showEmails([]);
  });
});

// Load immediately when popup opens
loadEmails();
